/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.api;

import mcp.mobius.waila.api.Accessor;
import mcp.mobius.waila.api.TooltipPosition;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;

public abstract class AccessorImpl<T extends HitResult>
implements Accessor<T> {
    private final Level level;
    private final Player player;
    private final CompoundTag serverData;
    private final T hit;
    private final boolean serverConnected;
    private TooltipPosition tooltipPosition;

    public AccessorImpl(Level level, Player player, CompoundTag serverData, T hit, boolean serverConnected) {
        this.level = level;
        this.player = player;
        this.serverData = serverData;
        this.hit = hit;
        this.serverConnected = serverConnected;
    }

    @Override
    public Level getLevel() {
        return this.level;
    }

    @Override
    public Player getPlayer() {
        return this.player;
    }

    @Override
    public CompoundTag getServerData() {
        return this.serverData == null ? new CompoundTag() : this.serverData;
    }

    @Override
    public T getHitResult() {
        return this.hit;
    }

    @Override
    public boolean isServerConnected() {
        return this.serverConnected;
    }

    @Override
    public TooltipPosition getTooltipPosition() {
        return this.tooltipPosition;
    }

    @Override
    public void _setTooltipPosition(TooltipPosition tooltipPosition) {
        this.tooltipPosition = tooltipPosition;
    }

    @Override
    public abstract ItemStack getPickedResult();
}

